package com.example.tp6_03.service;

import android.graphics.Bitmap;
import com.example.tp6_03.dto.CityDTO;
import com.example.tp6_03.dto.Mapper;
import com.example.tp6_03.dto.WeatherConditionDTO;
import com.example.tp6_03.model.City;
import com.example.tp6_03.network.HttpOperation;
import com.example.tp6_03.xml.XmlHandler;

import java.util.List;

public class RequestService {

    private static void getBitmapIcons(CityDTO city) {
        List<WeatherConditionDTO> weather = city.getWeather();
        for (WeatherConditionDTO day : weather) {
            if (day.getIcon() == null) {
                Bitmap icon = HttpOperation.getIcon(day.getIconUrl());
                city.setWeatherConditionIcon(day.getIconUrl(), icon);
            }
        }
    }

    private static CityDTO _getCityWeatherConditions(String urlStr) {
        CityDTO city = null;
        try {
            String jsonString = HttpOperation.get(urlStr);
            city = XmlHandler.deSerializeXml2CityDTO(jsonString);
            if (city != null) {
                getBitmapIcons(city);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return city;
    }

    public static City getCityWeatherConditions(String urlStr) {
        CityDTO cityDTO = _getCityWeatherConditions(urlStr);
        City city = Mapper.cityDTO2city(cityDTO);
        return city;

    }
}
